## 🧩 ACF Demo Application

### “Annual Report – Demo Furnitures Inc.”

---

### 🗂 Overview

This demo showcases how the **ACF Plugin** can be used inside **FileMaker** to generate a complete **Excel workbook** from database data — including **dynamic charts** and **cross-tab summaries** — all created directly through ACF script functions.

The demo is based on a fictive company **“Demo Furnitures Inc.”**, and produces an **Annual Report** spreadsheet with four automatically generated sheets:

1. **By Category × Period** – Sales totals grouped by product category and month
2. **By Seller × Period** – Sales totals grouped by salesperson and month
3. **By Product × Period** – Sales totals grouped by product and month
4. **By Seller details** – Per-seller summary tables with category and product breakdowns, each accompanied by two doughnut charts showing proportional sales distribution

All data is generated from a small sample of **1000 invoices** created by the included Python script (`generateDemoData.py`), stored in the FileMaker table `DemoInvoices`.

This demonstrates:

* The simplicity of **ACF’s SQL + array INTO** syntax for data extraction
* Automated creation of Excel workbooks, styles, and charts using **ACF Excel functions**
* How developers can combine SQL, JSON, and charting seamlessly in ACF scripts

---

### ⚙️ Requirements

* **FileMaker Pro 17 or later - Tested on FileMAker Pro 22**
* **ACF Plugin version 1.7.8.2 or newer**
  (Older versions lack required Excel chart functions.)

You can download the latest version of the plugin for your platform from:

* **macOS (ACF_Plugin.dmg)** → [https://horneks.no/downloads/acf-plugin-mac](https://horneks.no/?sdm_process_download=1&download_id=174)
* **Windows (ACF_Plugin.zip)** → [https://horneks.no/downloads/acf-plugin-win](https://horneks.no/?sdm_process_download=1&download_id=233)



---

### 📦 Installation

1. **Unzip the demo package**
   Extract the contents of the ZIP archive anywhere you prefer (e.g. your Desktop).
   Inside you’ll find:

   * `Demo-Furnitures.fmp12` (FileMaker file containing demo data and scripts)
   * `generateDemoData.py` (Python script for regenerating invoices)
   * `demo-excel-annualreport.acf` (ACF code used to build the report)
   * This `README.md`

2. **Install the ACF Plugin**

   #### macOS

   * In FileMaker, choose **Preferences → Plug-ins → Reveal Plug-ins Folder**
   * Copy  `ACF_Plugin.fmplugin` into that folder
     *(Default: `/Users/<you>/Library/Application Support/FileMaker/FileMaker Pro/22/Extensions/`)*
   * Restart FileMaker.

   #### Windows

   * In FileMaker, go to **Edit → Preferences → Plug-ins → Reveal Plug-ins Folder**
   * Copy `ACF_Plugin.fmx64` into that folder
     *(Default: `C:\Users\<you>\AppData\Local\FileMaker\FileMaker Pro\22\Extensions\`)*
   * Restart FileMaker.

3. **Verify installation**

   * Open FileMaker → **Preferences → Plug-ins**
   
   * Ensure “**ACF Plugin**” is listed and enabled.

     

---

### ▶️ Running the Demo

1. Open **Demo-Furnitures.fmp12** in FileMaker.
2. Click the **“Generate Annual Report”** button on the main layout.

   * The ACF script will query the invoice data via SQL,
     create arrays, build four Excel sheets, and add charts.
3. The generated workbook (`AnnualReport-DemoFurnitures.xlsx`) will be saved on your Desktop.
4. Open it in Excel to explore the results:

   * Pivot summaries for Category, Seller, and Product
   * Per-seller tables with color-coded doughnut charts

---

### 💡 Notes

* The Python script `generateDemoData.py` creates a small set (1000) of randomized invoices for the year 2024. You can rerun it anytime to regenerate the demo data. The CSV file must be imported into the table. 
* The report scripts are written entirely in **ACF language**, using standard plugin functions. They can be inspected and reused as examples for your own reports.
* The charts and table formatting are generated programmatically — no manual Excel templates are needed.

---

### 📘 Further Reading

For full documentation of the ACF Plugin and its Excel, SQL, and JSON capabilities, visit:
👉 [https://horneks.no/manuals/ACF/