# ACF Plugin v1.7.2.3 Release Notes

Welcome to the latest release of the ACF Plugin, version 1.7.2.3. This version marks a significant advancement in our commitment to quality and reliability. Below is an overview of the enhancements and fixes included in this release. Look at the version history for the latest improvements.

## Key Improvements

- Support inter-package function calls making it easy to create ACF libraries for use in your ACF programming.  
- Support for ZIP filesystems
- New Encryption/Decryption and HASH/HMAC functions
- New `sort_array` multi-sort function.

- The handling of complex XML and JSON data types has been meticulously tested on intricate structures. External validation has been conducted to guarantee that all operations within the plugin perform as expected.

- New function `SystemCommand` to execute OS commands from within the plugin function. 

## MacOS compatibility: 

- Intel Mac: From MacOS 10.13 High Sierra
- Arm (Silicon) Mac (M1, M2...) : From MacOS 12.3 Monterey
- All architectures can run up to the current MacOS 14.2 Somono

## Windows Compatibility:

- The 1.7.1.8 version is currently in beta-test. Licensed customers can obtain the beta release on request, otherwise others can obtain a license enrolling on the beta-tester program for 50% reduced price. Contact us for more info about this, 
- 64 bit Intel PC's with Windows-10 and Windows-11
- All 64 bit FileMaker versions. 

## Version History

### 1.7.2.3

- Added function `SystemCommand` to execute OS commands. The function has two parameters: Command, and directory path to `cd` into before the command is applied. 
- Added system variables HTTP_STATUS_CODE and HTTP_HEADERS, those can be used when working with API's, to verify request went OK (200), and for the headers - it is now possible to extract cookies from the headers to be used with authentication protocols when working with web-services. 

### 1.7.2.2

- Corrected issue with global variables sometimes not working correctly. Compiler issue. 

### 1.7.2.1

- New function `SystemCommand` to execute operating system commands from within the ACF function. 
  Parameters: `SystemCommand ("Command", "/path/to/directory/to/cd/into", environment); 
  environment is default "/bin/bash" if this parameter is omitted. On Windows: "cmd"

### 1.7.2.0

- Fixed issue with JSON and XML implementation where there is no root object, and asignment a single tag. 
- Fixed issue with handling of SQL errors. Returned only "?" as the function result, and a error on the console. However, the error did not gave enough insight to be able to debug the issue, especially when using placeholders one could not see the actual SQL statement that gave the error. This is now fixed with a print on the console giving the SQL statement. The function also returns the error in question instead of the "?". 
- Fixed Escaping of SQL literal content. The literals use single apostrophes on each side, and single apostrophes inside the literal was escaped with ```\'``` - that was not correct for SQL. Correct escaping is two single apostrophes, like: ```''``` instead. Now fixed. Problem was most experieced when updating or inserting user content in the database. 

### 1.7.1.8

- Fixed a compiler bug in the `Power (^)` function, which occurred when operands were non-float values. The incorrect return type caused calculation errors, such as `3*5^0` producing an erroneous result, while `3*5.0^0.0` returned the correct result.
- Added functions: 
  - Log10 - Calculate briggs logarithm of the argument
  - LogLn - Calculate natural logarthm of the argument. 


### 1.7.1.7

- Fixed bug in date and timestamp formatting functions, where on Windows plattform an invalid format string made Filemaker quit unexpectedly. The issue has never been seen on MacOS. The fix causes now a runtime error with a propper message in the function instead. 
- Implemented math trigonometric functions `asin`, `acos`, and `atan` . 
- Implemented check for curl CA-certificate environment variable `CURL_CA_BUNDLE`. If it exists and pointing to a certificate file containing the CA-certificates, the plugin uses this when executing `HTTP_GET`, `HTTP_POST` and `SEND_EMAIL` functions when using the SSL protocoll. This is usually not needed for MacOS, as it has such a file in its default location, but Windows uses a different system for CA-certificates that makes download and install such file in the system neccessary to speak over the SSL protocoll. For some special sites, it might be neccessary to use a different CA file, and this is now possible. 
- Break inside for-loop didn't pop the step variable, so console received a warning about something left on stack at return. Fixed. 

### 1.7.1.6

- Fixed a bug in handling SQL placeholders in SQL statements. The ":" prefix of the variable names was also checked inside string literals making it impossible to update or insert literal values containing a colon. 

### 1.7.1.5

- Added function "proper" which makes the title case of a given string as a parameter, (in the family of upper/lower functions). This is also a standard FileMaker function, but now also standard in ACF. 

### 1.7.1.4

- Bugfix: The ACF functions `upper` and `lower` to convert a string to uppercase and lowercase did not check if the current locale was initialized. This caused a runtime exception if not initialized by other functions. Fixed in this version. Bug introduced in 1.7.1.3 as an optimization task to reduce the overhead of the startup of the ACF functions. 

### 1.7.1.3

- Optimized code for ACF_run startup, delayed initialization of locale until needed. Removed 1.3mS from startup code, down to 0.1mS

### 1.7.1.2

- Added native TRIM functions to trim left, right and both sides of a text string. The function trims away white space including CR, LF, TAB, SPACE, and NBSP ( 0xC2 0xA0). 

  - `TrimBoth` - Both sides
  - `TrimLeft` and `TrimRight` for either side. 

  The functions are highly effective, trims a string in less than 2uS. (Tested with 200 char string and mix of white space on each side in a loop running 10.000 trim operations). 

### 1.7.1.1

- In version 1.7.1.1, we've fixed a critical bug causing a 1-byte displacement in the binary output when referencing inter-package functions via the `USE` statement, which previously led to unloadable compiled packages. We've introduced an updated, more reliable method to prevent this issue, rolling out file format version 2 that retains compatibility with the original format. Format version 1 is deprecated and treated as version 0, excluding inter-package link tables. Users are encouraged to update to ensure compatibility and take advantage of these corrections. **All packages compiled with 1.7.1.0 must be recompiled with this plugin version.**

### 1.7.1.0

- Implemented "USE" statement to allow inter-package function calls. With the "use" statement, you tell the package that it can call functions in the other namespace (another package name). See an example in the [article addressing](https://horneks.no/manuals/ACF/inter-packagefunctioncalls.html) this feature. 
- Corrected some minor bugs: The "repeat-until" falsely reported a "left content on stack" warning. 

### 1.7.0.20

- Discovered bug in date, time, and timestamp compare construct. Fixed. 
- New functions: `open_zip` and `close_zip`functions and included all filesystem operations to work on paths inside ZIP archives, see [article about ZIP file support here](https://horneks.no/manuals/ACF/woekinfwithzipfiles.html) 

### 1.7.0.19

- The functions `left`, `right`, `substr`, and  `mid`  handle UTF8 strings based on characters instead of bytes. for example `left("bæææ", 3)` returns `bææ` that represents 5 bytes. (each "æ" is two bytes: C3 A6). This change will ensure that multi-byte characters don't got cut. 
- The functions `char` and `ascii` now use Unicode representation instead of pure ASCII values. For `ascii,` it means that if the first character in a string is a multibyte UTF8 character, it will return the unicode for that character instead of only the first byte. Also, char` - will produce a string with the UTF8 character based on the Unicode taken as a parameter. 
- The functions `upper` and `lower` now use the currently active locale set by `set_locale` to handle locale-specific conversion to upper and lowercase strings. 
- The function `length` now counts characters in a string, instead of bytes. This means that `length("bææ")`returns 3, instead of 5 bytes. This works well in most cases. 
- The new function `bytes` return the actual number of bytes in the string. 
- Some adjustments to the format function and UTF8 strings. s-format with length now fits with multi-byte UTF8 strings, so that the length is expanded with the extra number of bytes required to fit the string. For example, the format %-10s (left justified string, 10 char), and the string "Bodø" that is 5 bytes, will expand the format to %-11s, so that the 6-space padding makes the result 10 characters.  

### 1.7.0.18

- Included `boost_locale` and the `ICU` libraries to improve the following functions about UTF-8 handling: 
- ICU stands for "International Components for Unicode." It is a mature, widely used set of C/C++ and Java libraries that provide robust and full-featured Unicode and locale support. This includes functions for string comparison, normalization, conversion between different character encodings, date/time formatting, and language-sensitive text collation. ICU is extensively used in various applications and platforms for internationalization (i18n) to ensure that software can be used in multiple languages and cultural contexts.
  - New command: `set_locale`. See the reference on page: [new locale command](https://horneks.no/manuals/ACF/setlocale.html) for the syntax and a list of often-used locale codes. 
  - The `sort_array` command now uses the locale for the correct sorting of national characters. 
  - The compare function can now use the correct locale when comparing strings with `if (string1<string2) then` statement. 
  - The `regex` functions are improved and now use ICU for special UTF8 characters.  

### 1.7.0.17

- new functions: encrypt and decrypt. See manual page: [encryption/decrypt functions](https://horneks.no/manuals/ACF/encryptionanddecryption.html)
- new function: sort_array - multi-array multi-level sorting function for sorting a single array or a group of arrays. See manual page [sort_array function](https://horneks.no/manuals/ACF/sortarrayfunction.html)

### 1.7.0.16

- Two new ACF functions, `create_hash` and `create_hmac` for generating message digests for all the methods: MD5, SHA1, SHA256, SHA384, and SHA512. Documentation can be found on the following WEB-page: [horneks.no/manuals/ACF/createhashfunction.html](https://horneks.no/manuals/ACF/createhashfunction.html)

### 1.7.0.15

- Implemented new language grammar features: 
  - Conditional expressions (see [Syntax differences, conditional expressions](https://horneks.no/manuals/ACF/somesyntaxdifferences.html#toc1-2-0) )
  - Case ... end case structures. (see [Case structures](https://horneks.no/manuals/ACF/programmingbasics.html#toc1-7-3))
  - `break` statement to exit loops and case constructs. A break that is placed inside an if-construct will break out of the loop surrounding it. Breaks inside case constructs break out of the case and continue execution after `end case`. The break statement exits any type of loop construct being for, while, or repeat until. 

### 1.7.0.12

- The `send_email` function has been enhanced to encode display names in email addresses and the subject line, ensuring compliance with email standards. Additionally, we've refined the processing of lengthy subject lines by appropriately splitting them across multiple lines in the mail headers. For emails with numerous recipients in the "To" or "Cc" fields, our improved implementation now effectively splits these lines following RFC standards. The encoding utilized is UTF-8 with Quoted Printable. It's worth noting that the encoding of different body parts was already accurately implemented starting from version 1.7.0.9.

### 1.7.0.11

- Fixed bug in send_email where mail contained several inline images. The styling of the HTML mail was incorrect. 

### 1.7.0.10

- Fixed a little bug in the `send_email` implementation. It did not recognize correctly the email addresses on the form `name <myemail@example.com>` , only the naked emails without the name in front. 
- Updated the TextMate editor bundle to correctly handle indentation and added some new language functions. It is in the download DMG. 

### 1.7.0.9

- Implemented send_email function, according to the web page at: 
  https://horneks.no/manuals/ACF/sendane-mailfromtheacfplugin.html

### 1.7.0.8

- Resolved SSL issues on macOS Sonoma by updating the cURL and OpenSSL libraries. Previously, the plugin used cURL with LibreSSL, which was compatible with earlier macOS versions but not with Sonoma. The plugin now utilizes cURL with OpenSSL 3.0.9. This update is essential for the proper functioning of HTTP_GET, HTTP_POST, and document service functions. 

### 1.7.0.7

- Plugin and installer dmg is now Notarized @ apple, so there should be no issues installing the plugin on newer MacOS releases. Tested with MacOS Sonomoa 14.2
- Minor adjustments to XML implementation for improved handling of intermediate XML documents. When attaching intermediate XMLs to a master document, if the intermediate document's root element is "intermediateRoot", only its child elements are attached. The function for adding key/value pair lists now encapsulates the list within an "intermediateRoot" element. Conversely, other ACF functions return XML nodes without this wrapper. This approach greatly facilitates the construction of complex XML structures, allowing for seamless assembly of disparate parts into a unified master document. This implementation strategy is essential due to XML's limitation of only allowing a single root element per document. Further details will be provided in the documentation.

### 1.7.0.6

- ##### Quality Assurance Enhancements

  - Our team has made substantial efforts in the quality assurance department to ensure the highest standards. The ACF compiler, integral to the plugin, now more accurately predicts stack usage for the runtime, focusing on data types involved in various operations.
  - We've implemented automated testing and detailed logging, leading to the identification and resolution of several critical issues. These efforts have significantly enhanced the overall stability and quality of the plugin.
  - New functions - Check the revision history below for details. 

### 1.7.0.5

- Minor adjustments to JSON functionality for alignment with XML implementation.

### 1.7.0.4

- Enhanced debugging of XML functions.

### 1.7.0.3

- Introduction of XML support functions and data type.
- Seamless XML to JSON conversion capabilities.

### 1.7.0.2b

- Incorporation of JSON support as detailed at [ACF JSON Data Type Documentation](https://horneks.no/manuals/ACF/jsondatatypeintheacflanguage.html).

### 1.7.0.1

- Enhanced document service with one-time password security.
- Introduction of Confirm, Alert, and Request functions for exception handling.
- Robust TRY/CATCH/TRY AGAIN logic for exceptions.

### 1.7.0.0

- New HTTP_Get and HTTP_Post functions.
- Enhanced OTP functions for Two-factor authentication.
- Advanced SQL functionality with placeholders.
- Updated MySQL compatibility.
- Refined Document Service functions.
- New BASE64_ENCODE, BASE32_ENCODE, BASE64_DECODE, BASE32_DECODE functions.

## Bug Fixes

- Addressed issues with compiling nameless packages. Nameless packages are now labeled "STD".
- Overhauled document service for improved stability, particularly in handling unusual parameters.
- Implemented 'List_files', absent in version 1.6.2.
- Introduced 'Delete_directory', though usage advisories apply due to potential risks with incorrect path specifications.

## Documentation

For detailed information and guidance, visit our [online documentation](https://horneks.no/manuals/ACF/index.html).

Additionally, an offline version of the documentation, as of 09.12.2023, is included in this download. Start with the `index.html` file at the top of the archive for offline reference.

---

Your feedback and suggestions are invaluable to us. If you have any thoughts or concerns, especially regarding features like 'Delete_directory', we welcome your input. Thank you for choosing the ACF Plugin!