**Hello Beta Tester,**

This is the Windows version (1.7.2.3) of the ACF Plugin. Since this version is brand new, there are a few quick steps to install it. You’ll find everything you need in the attached ZIP archive.

If you haven't got a license yet, the plugin will work in 30 minutes, and then stop working. Then you have to restart FileMaker to get another 30 minutes. This can be fine for testing, but I encourage you to visit our shop and buy a license, then you can run the plugin as long as you want without any interruptions. Our shop is at http://horneks.no/butikk Until 14.11.2024, you can obtain a 50% discount using the cupon code "BETATESTER". 

\### **Step 1 - Plugin Certificate**

While the Mac version of the plugin is signed with my developer certificate and notarized by Apple, the Windows beta release is currently signed with a self-generated certificate. This certificate is intended for a limited group of beta testers. For the official release, we will obtain an official certificate. For now, this certificate must be imported into the Windows "cert-manager" application. I am the only one who can sign applications with this certificate, so it is completely safe to use.

\- If you previously has done this step, you can safely move on to step 2. 

\- Search for the program `certmgr.msc` in the Windows search bar (bottom left corner) and open it.

\- In the left-hand menu, navigate to "Trusted Root Certification Authorities." Expand the menu and go to "Certificates" under that.

\- Right-click on "Certificates," select "All Tasks," and then choose "Import."

\- In the Import Wizard, select the certificate from the unzipped folder. The file is named "Horneks-pub.cer."

\- Complete the wizard and confirm any security warnings that may appear.

\- After this step, FileMaker will accept the plugin without further prompts.



\### **Step 2 - Installing the Plugin**

\- Open FileMaker without starting any applications in it. 

\- In the FileMaker menu, go to "Edit" and select "Preferences."

\- In the dialog box that appears, go to the "Plugins" tab.

\- Click the "Reveal plugin folder" button.

\- In the Windows Explorer window that opens, copy the "ACF-Plugin.fmx64" file into the folder. If the file already exists, choose to overwrite it.

\- Close FileMaker, restart it, and return to the Preferences panel. You should now see the ACF Plugin listed.

\### Step 3 - Curl CA Certificates



\- We are internally using the curl library for HTTP GET/POST requests, as well as for sending emails. To ensure curl has access to the necessary chain of certificates (CA certificates), you can configure an environment variable pointing to the certificate file. This can easily be done as follows:

\- In the release package, there is a file called `cacert.pem`. Copy this to a preferred location on your computer. You can later download updated root certificates from [curl's CA extract page](http://curl.haxx.se/docs/caextract.html). Take note of the path to this certificate, such as `C:\windows\system32\ssl\cacert.pem` or any other location of your choice.

\- Search for "Environment Variables" in the Windows search bar (bottom left corner). Open the application that appears.

\- Add a new system variable, name it `CURL_CA_BUNDLE`, and for the value, use the path to the `cacert.pem` file.

\- With this in place, all SSL-related functions will work without SSL errors. This will also work for the curl command-line application.

You can now begin testing the ACF Plugin. Happy coding!

I suggest that you read in the [reference manual](https://horneks.no/manuals/ACF/index.html) to make yourself familiar with the plugin. 

Good luck!

Best Regards, 

\-

 **Ole Kristian Ek Hornnes**

 System Consultant / Developer

 Tlf: 98355884, Epost: ole@horneks.no 